import { Document, Model, Types } from 'mongoose';
export type PublicationType = 'news' | 'article' | 'announcement' | 'faq';
export type PublicationStatus = 'draft' | 'published' | 'archived';
export interface PublicationDocument extends Document {
    id: string;
    authorId?: Types.ObjectId;
    title: string;
    slug: string;
    content: string;
    type: PublicationType;
    tags?: string[];
    status: PublicationStatus;
    publishedAt?: Date;
    isDeleted?: boolean;
    deletedAt?: Date;
    createdAt: Date;
    updatedAt: Date;
}
export declare const Publication: Model<PublicationDocument>;
