"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Product = void 0;
const mongoose_1 = __importStar(require("mongoose"));
const base_1 = require("./base");
const providerMappingSchema = new mongoose_1.Schema({
    providerId: { type: mongoose_1.Schema.Types.ObjectId, ref: 'ServiceProvider', required: true },
    providerName: { type: String },
    vendorCode: { type: String, required: true },
    costPrice: { type: Number, required: true },
    status: { type: String, enum: ['active', 'inactive', 'low_balance', 'maintenance'], default: 'active' },
    lastUpdated: { type: Date },
}, { _id: false });
const productSchema = new mongoose_1.Schema({
    canonicalCode: { type: String, required: true, unique: true, index: true },
    name: { type: String, required: true },
    type: { type: String, enum: ['data', 'airtime'], required: true, index: true },
    network: { type: String, enum: ['mtn', 'airtel', 'glo', '9mobile'], required: true, index: true },
    dataPlanType: { type: String, enum: ['sme', 'sme2', 'corporate', 'awoof', 'gifting'] },
    size: { type: String },
    validity: { type: String },
    pricingMode: { type: String, enum: ['fixed', 'margin', 'dynamic'], default: 'fixed' },
    sellingPrice: { type: Number },
    marginPercent: { type: Number },
    maxAllowedCost: { type: Number },
    isVisible: { type: Boolean, default: true, index: true },
    providers: { type: [providerMappingSchema], default: [] },
    isDeleted: { type: Boolean, default: false, index: true },
    deletedAt: { type: Date },
}, base_1.baseSchemaOptions);
productSchema.index({ type: 1, network: 1, isVisible: 1 });
exports.Product = mongoose_1.default.models['Product'] || mongoose_1.default.model('Product', productSchema);
