import { Document, Model, Types } from 'mongoose';
export type ProductPricingMode = 'fixed' | 'margin' | 'dynamic';
export interface ProductProviderMapping {
    providerId: Types.ObjectId;
    providerName?: string;
    vendorCode: string;
    costPrice: number;
    status?: 'active' | 'inactive' | 'low_balance' | 'maintenance';
    lastUpdated?: Date;
}
export interface ProductDocument extends Document {
    id: string;
    canonicalCode: string;
    name: string;
    type: 'data' | 'airtime';
    network: 'mtn' | 'airtel' | 'glo' | '9mobile';
    dataPlanType?: 'sme' | 'sme2' | 'corporate' | 'awoof' | 'gifting';
    size?: string;
    validity?: string;
    pricingMode: ProductPricingMode;
    sellingPrice?: number;
    marginPercent?: number;
    maxAllowedCost?: number;
    isVisible: boolean;
    providers: ProductProviderMapping[];
    createdAt: Date;
    updatedAt: Date;
    deletedAt?: Date;
    isDeleted?: boolean;
}
export declare const Product: Model<ProductDocument>;
