"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ledger = void 0;
const mongoose_1 = __importStar(require("mongoose"));
const base_1 = require("./base");
const ledgerSchema = new mongoose_1.Schema({
    transactionId: { type: mongoose_1.Schema.Types.ObjectId, ref: 'Transaction', required: true, index: true },
    userId: { type: mongoose_1.Schema.Types.ObjectId, ref: 'User', index: true },
    accountType: { type: String, enum: ['asset', 'liability', 'equity', 'revenue', 'expense'], required: true, index: true },
    accountCode: { type: String, required: true, index: true },
    entryType: { type: String, enum: ['debit', 'credit'], required: true },
    amount: { type: Number, required: true },
    currency: { type: String, enum: ['NGN', 'USD'], default: 'NGN' },
    balanceBefore: { type: Number, required: true },
    balanceAfter: { type: Number, required: true },
    status: { type: String, enum: ['pending', 'posted', 'reversed', 'cancelled'], default: 'pending', index: true },
    description: { type: String, required: true },
    reference: { type: String, required: true, index: true },
    metadata: { type: mongoose_1.Schema.Types.Mixed },
    postedAt: { type: Date },
    reversedAt: { type: Date },
    reversedBy: { type: mongoose_1.Schema.Types.ObjectId, ref: 'User' },
}, base_1.baseSchemaOptions);
ledgerSchema.index({ transactionId: 1, entryType: 1 });
ledgerSchema.index({ accountCode: 1, createdAt: -1 });
ledgerSchema.index({ userId: 1, accountType: 1, createdAt: -1 });
ledgerSchema.index({ status: 1, createdAt: -1 });
exports.Ledger = mongoose_1.default.models['Ledger'] || mongoose_1.default.model('Ledger', ledgerSchema);
