import { Document, Model, Types } from 'mongoose';
export type AccountType = 'asset' | 'liability' | 'equity' | 'revenue' | 'expense';
export type EntryType = 'debit' | 'credit';
export type LedgerStatus = 'pending' | 'posted' | 'reversed' | 'cancelled';
export interface LedgerDocument extends Document {
    id: string;
    transactionId: Types.ObjectId;
    userId?: Types.ObjectId;
    accountType: AccountType;
    accountCode: string;
    entryType: EntryType;
    amount: number;
    currency: 'NGN' | 'USD';
    balanceBefore: number;
    balanceAfter: number;
    status: LedgerStatus;
    description: string;
    reference: string;
    metadata?: Record<string, any>;
    postedAt?: Date;
    reversedAt?: Date;
    reversedBy?: Types.ObjectId;
    createdAt: Date;
    updatedAt: Date;
}
export declare const Ledger: Model<LedgerDocument>;
