import { Document, Model, Types } from 'mongoose';
export type JambServiceType = 'admission_status' | 'profile_code_retrieval' | 'olevel_upload' | 'original_result_printing' | 'admission_letter_printing' | 'slip_reprinting';
export type JambRequestStatus = 'pending' | 'in_progress' | 'completed' | 'failed';
export interface JambRequestDocument extends Document {
    id: string;
    userId: Types.ObjectId;
    serviceType: JambServiceType;
    price: number;
    payload: Record<string, any>;
    status: JambRequestStatus;
    resultUrl?: string;
    notes?: string;
    createdAt: Date;
    updatedAt: Date;
}
export declare const JambRequest: Model<JambRequestDocument>;
