import { Document, Model, Types } from 'mongoose';
export type FundingMethod = 'bank_transfer' | 'card_payment' | 'paystack' | 'flutterwave' | 'manual';
export type FundingStatus = 'pending' | 'processing' | 'successful' | 'failed' | 'cancelled' | 'reversed';
export type FundingType = 'instant' | 'manual' | 'scheduled';
export interface FundingDocument extends Document {
    id: string;
    userId: Types.ObjectId;
    walletId: Types.ObjectId;
    transactionId?: Types.ObjectId;
    method: FundingMethod;
    type: FundingType;
    amount: number;
    currency: 'NGN' | 'USD';
    fee: number;
    vat: number;
    netAmount: number;
    status: FundingStatus;
    reference: string;
    externalReference?: string;
    bankDetails?: {
        bankName: string;
        accountNumber: string;
        accountName: string;
        narration?: string;
    };
    cardDetails?: {
        last4: string;
        brand: string;
        expiryMonth: number;
        expiryYear: number;
    };
    paymentProvider?: {
        name: string;
        transactionId: string;
        metadata: Record<string, any>;
    };
    scheduledAt?: Date;
    processedAt?: Date;
    failedAt?: Date;
    failureReason?: string;
    metadata?: Record<string, any>;
    createdAt: Date;
    updatedAt: Date;
}
export declare const Funding: Model<FundingDocument>;
