"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dispute = void 0;
const mongoose_1 = __importStar(require("mongoose"));
const base_1 = require("./base");
const disputeSchema = new mongoose_1.Schema({
    userId: { type: mongoose_1.Schema.Types.ObjectId, ref: 'User', required: true, index: true },
    transactionId: { type: mongoose_1.Schema.Types.ObjectId, ref: 'Transaction', required: true, index: true },
    type: { type: String, enum: ['chargeback', 'refund_request', 'fraud', 'service_dispute', 'billing_dispute'], required: true, index: true },
    status: { type: String, enum: ['opened', 'under_review', 'evidence_required', 'resolved', 'closed', 'won', 'lost'], default: 'opened', index: true },
    priority: { type: String, enum: ['low', 'medium', 'high', 'urgent'], default: 'medium', index: true },
    reason: { type: String, required: true },
    description: { type: String, required: true },
    amount: { type: Number, required: true },
    currency: { type: String, enum: ['NGN', 'USD'], default: 'NGN' },
    reference: { type: String, required: true, unique: true, index: true },
    externalReference: { type: String },
    evidence: {
        documents: [String],
        notes: String,
        submittedAt: Date,
    },
    resolution: {
        outcome: { type: String, enum: ['refunded', 'reversed', 'upheld', 'partial_refund'] },
        amount: Number,
        reason: String,
        resolvedBy: { type: mongoose_1.Schema.Types.ObjectId, ref: 'User' },
        resolvedAt: Date,
    },
    timeline: [{
            status: { type: String, enum: ['opened', 'under_review', 'evidence_required', 'resolved', 'closed', 'won', 'lost'] },
            note: String,
            updatedBy: { type: mongoose_1.Schema.Types.ObjectId, ref: 'User' },
            updatedAt: { type: Date, default: Date.now },
        }],
    metadata: { type: mongoose_1.Schema.Types.Mixed },
}, base_1.baseSchemaOptions);
disputeSchema.index({ userId: 1, createdAt: -1 });
disputeSchema.index({ status: 1, priority: 1, createdAt: -1 });
disputeSchema.index({ type: 1, status: 1 });
disputeSchema.index({ externalReference: 1 });
exports.Dispute = mongoose_1.default.models['Dispute'] || mongoose_1.default.model('Dispute', disputeSchema);
