import { Document, Model, Types } from 'mongoose';
export type DisputeType = 'chargeback' | 'refund_request' | 'fraud' | 'service_dispute' | 'billing_dispute';
export type DisputeStatus = 'opened' | 'under_review' | 'evidence_required' | 'resolved' | 'closed' | 'won' | 'lost';
export type DisputePriority = 'low' | 'medium' | 'high' | 'urgent';
export interface DisputeDocument extends Document {
    id: string;
    userId: Types.ObjectId;
    transactionId: Types.ObjectId;
    type: DisputeType;
    status: DisputeStatus;
    priority: DisputePriority;
    reason: string;
    description: string;
    amount: number;
    currency: 'NGN' | 'USD';
    reference: string;
    externalReference?: string;
    evidence?: {
        documents: string[];
        notes: string;
        submittedAt: Date;
    };
    resolution?: {
        outcome: 'refunded' | 'reversed' | 'upheld' | 'partial_refund';
        amount: number;
        reason: string;
        resolvedBy: Types.ObjectId;
        resolvedAt: Date;
    };
    timeline: Array<{
        status: DisputeStatus;
        note: string;
        updatedBy: Types.ObjectId;
        updatedAt: Date;
    }>;
    metadata?: Record<string, any>;
    createdAt: Date;
    updatedAt: Date;
}
export declare const Dispute: Model<DisputeDocument>;
