"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.BillPayment = void 0;
const mongoose_1 = __importStar(require("mongoose"));
const base_1 = require("./base");
const billPaymentSchema = new mongoose_1.Schema({
    userId: { type: mongoose_1.Schema.Types.ObjectId, ref: 'User', required: true, index: true },
    transactionId: { type: mongoose_1.Schema.Types.ObjectId, ref: 'Transaction', index: true },
    type: { type: String, enum: ['electricity', 'cable_tv', 'internet', 'exam_pin'], required: true, index: true },
    biller: { type: String, enum: ['ikeja_electric', 'eko_electric', 'dstv', 'gotv', 'startimes', 'spectranet', 'smile', 'waec', 'neco', 'jamb', 'others'], required: true, index: true },
    customerId: { type: String, required: true, trim: true, index: true },
    amount: { type: Number, required: true },
    productCode: { type: String, trim: true },
    status: { type: String, enum: ['pending', 'processing', 'successful', 'failed', 'reversed'], default: 'pending', index: true },
    provider: { type: String, enum: ['paystack', 'flutterwave', 'others'], required: true, index: true },
    providerReference: { type: String, trim: true, index: true },
    token: { type: String, trim: true },
    metadata: { type: mongoose_1.Schema.Types.Mixed },
    isDeleted: { type: Boolean, default: false, index: true },
    deletedAt: { type: Date },
}, base_1.baseSchemaOptions);
billPaymentSchema.index({ userId: 1, createdAt: -1 });
billPaymentSchema.index({ customerId: 1, createdAt: -1 });
exports.BillPayment = mongoose_1.default.models['BillPayment'] || mongoose_1.default.model('BillPayment', billPaymentSchema);
