import { Document, Model, Types } from 'mongoose';
export type BillType = 'electricity' | 'cable_tv' | 'internet' | 'exam_pin';
export type Biller = 'ikeja_electric' | 'eko_electric' | 'dstv' | 'gotv' | 'startimes' | 'spectranet' | 'smile' | 'waec' | 'neco' | 'jamb' | 'others';
export type BillStatus = 'pending' | 'processing' | 'successful' | 'failed' | 'reversed';
export interface BillPaymentDocument extends Document {
    id: string;
    userId: Types.ObjectId;
    transactionId?: Types.ObjectId;
    type: BillType;
    biller: Biller;
    customerId: string;
    amount: number;
    productCode?: string;
    status: BillStatus;
    provider: 'paystack' | 'flutterwave' | 'others';
    providerReference?: string;
    token?: string;
    metadata?: Record<string, any>;
    isDeleted?: boolean;
    deletedAt?: Date;
    createdAt: Date;
    updatedAt: Date;
}
export declare const BillPayment: Model<BillPaymentDocument>;
