"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseModel = exports.baseSchema = exports.baseSchemaOptions = void 0;
const mongoose_1 = __importStar(require("mongoose"));
exports.baseSchemaOptions = {
    timestamps: true,
    toJSON: {
        transform: (_doc, ret) => {
            ret.id = ret._id;
            delete ret._id;
            delete ret.__v;
            return ret;
        },
    },
    toObject: {
        transform: (_doc, ret) => {
            ret.id = ret._id;
            delete ret._id;
            delete ret.__v;
            return ret;
        },
    },
};
exports.baseSchema = new mongoose_1.Schema({}, exports.baseSchemaOptions);
class BaseModel {
    model;
    constructor(model) {
        this.model = model;
    }
    async create(data) {
        const document = new this.model(data);
        return await document.save();
    }
    async findById(id) {
        if (!mongoose_1.default.Types.ObjectId.isValid(id)) {
            return null;
        }
        return await this.model.findById(id);
    }
    async find(filter = {}) {
        return await this.model.find(filter);
    }
    async findOne(filter = {}) {
        return await this.model.findOne(filter);
    }
    async updateById(id, data) {
        if (!mongoose_1.default.Types.ObjectId.isValid(id)) {
            return null;
        }
        return await this.model.findByIdAndUpdate(id, data, { new: true, runValidators: true });
    }
    async deleteById(id) {
        if (!mongoose_1.default.Types.ObjectId.isValid(id)) {
            return false;
        }
        const result = await this.model.findByIdAndDelete(id);
        return result !== null;
    }
    async count(filter = {}) {
        return await this.model.countDocuments(filter);
    }
    async exists(filter) {
        const count = await this.model.countDocuments(filter);
        return count > 0;
    }
    getModel() {
        return this.model;
    }
}
exports.BaseModel = BaseModel;
