import mongoose, { Document, Model } from 'mongoose';
export interface BaseDocument extends Document {
    createdAt: Date;
    updatedAt: Date;
    id: string;
}
export interface BaseCreateInput {
    [key: string]: any;
}
export interface BaseUpdateInput {
    [key: string]: any;
}
export interface BaseQueryInput {
    page?: number;
    limit?: number;
    sort?: Record<string, 1 | -1>;
    search?: string;
    [key: string]: any;
}
export interface PaginatedResult<T> {
    data: T[];
    pagination: {
        page: number;
        limit: number;
        total: number;
        totalPages: number;
        hasNext: boolean;
        hasPrev: boolean;
    };
}
export declare const baseSchemaOptions: {
    timestamps: boolean;
    toJSON: {
        transform: (_doc: any, ret: any) => any;
    };
    toObject: {
        transform: (_doc: any, ret: any) => any;
    };
};
export declare const baseSchema: mongoose.Schema<any, mongoose.Model<any, any, any, any, any, any>, {}, {}, {}, {}, {
    timestamps: boolean;
    toJSON: {
        transform: (_doc: any, ret: any) => any;
    };
    toObject: {
        transform: (_doc: any, ret: any) => any;
    };
}, {}, any>;
export declare abstract class BaseModel<T extends BaseDocument> {
    protected model: Model<T>;
    constructor(model: Model<T>);
    create(data: BaseCreateInput): Promise<T>;
    findById(id: string): Promise<T | null>;
    find(filter?: Record<string, any>): Promise<T[]>;
    findOne(filter?: Record<string, any>): Promise<T | null>;
    updateById(id: string, data: BaseUpdateInput): Promise<T | null>;
    deleteById(id: string): Promise<boolean>;
    count(filter?: Record<string, any>): Promise<number>;
    exists(filter: Record<string, any>): Promise<boolean>;
    getModel(): Model<T>;
}
export interface IBaseRepository<T extends BaseDocument> {
    create(data: BaseCreateInput): Promise<T>;
    findById(id: string): Promise<T | null>;
    find(filter?: Record<string, any>): Promise<T[]>;
    findOne(filter?: Record<string, any>): Promise<T | null>;
    updateById(id: string, data: BaseUpdateInput): Promise<T | null>;
    deleteById(id: string): Promise<boolean>;
    count(filter?: Record<string, any>): Promise<number>;
    exists(filter: Record<string, any>): Promise<boolean>;
}
export interface IBaseService<T extends BaseDocument> {
    create(data: BaseCreateInput): Promise<T>;
    findById(id: string): Promise<T | null>;
    find(filter?: Record<string, any>): Promise<T[]>;
    findOne(filter?: Record<string, any>): Promise<T | null>;
    updateById(id: string, data: BaseUpdateInput): Promise<T | null>;
    deleteById(id: string): Promise<boolean>;
    count(filter?: Record<string, any>): Promise<number>;
    exists(filter: Record<string, any>): Promise<boolean>;
}
