"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.gracefulShutdown = exports.checkDatabaseHealth = exports.getDatabaseStatus = exports.disconnectDatabase = exports.connectDatabase = exports.databaseManager = exports.DatabaseManager = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
const database_1 = require("../config/database");
Object.defineProperty(exports, "connectDatabase", { enumerable: true, get: function () { return database_1.connectDatabase; } });
Object.defineProperty(exports, "disconnectDatabase", { enumerable: true, get: function () { return database_1.disconnectDatabase; } });
Object.defineProperty(exports, "getDatabaseStatus", { enumerable: true, get: function () { return database_1.getDatabaseStatus; } });
Object.defineProperty(exports, "checkDatabaseHealth", { enumerable: true, get: function () { return database_1.checkDatabaseHealth; } });
Object.defineProperty(exports, "gracefulShutdown", { enumerable: true, get: function () { return database_1.gracefulShutdown; } });
const logger_1 = require("../config/logger");
class DatabaseManager {
    static instance;
    isConnected = false;
    connectionPromise = null;
    constructor() {
        this.setupEventListeners();
    }
    static getInstance() {
        if (!DatabaseManager.instance) {
            DatabaseManager.instance = new DatabaseManager();
        }
        return DatabaseManager.instance;
    }
    setupEventListeners() {
        mongoose_1.default.connection.on('connected', () => {
            this.isConnected = true;
            logger_1.logger.info('MongoDB connected successfully');
        });
        mongoose_1.default.connection.on('disconnected', () => {
            this.isConnected = false;
            logger_1.logger.warn('MongoDB disconnected');
        });
        mongoose_1.default.connection.on('error', (error) => {
            this.isConnected = false;
            logger_1.logger.error('MongoDB connection error:', error);
        });
        mongoose_1.default.connection.on('reconnected', () => {
            this.isConnected = true;
            logger_1.logger.info('MongoDB reconnected');
        });
        process.on('SIGINT', () => (0, database_1.gracefulShutdown)('SIGINT'));
        process.on('SIGTERM', () => (0, database_1.gracefulShutdown)('SIGTERM'));
        process.on('SIGQUIT', () => (0, database_1.gracefulShutdown)('SIGQUIT'));
    }
    async connect() {
        if (this.isConnected) {
            logger_1.logger.info('Database already connected');
            return;
        }
        if (this.connectionPromise) {
            logger_1.logger.info('Connection already in progress, waiting...');
            return this.connectionPromise;
        }
        this.connectionPromise = this.performConnection();
        return this.connectionPromise;
    }
    async performConnection() {
        try {
            await (0, database_1.connectDatabase)();
            this.isConnected = true;
            this.connectionPromise = null;
        }
        catch (error) {
            this.isConnected = false;
            this.connectionPromise = null;
            throw error;
        }
    }
    async disconnect() {
        if (!this.isConnected) {
            logger_1.logger.info('Database already disconnected');
            return;
        }
        try {
            await (0, database_1.disconnectDatabase)();
            this.isConnected = false;
        }
        catch (error) {
            logger_1.logger.error('Error disconnecting from database:', error);
            throw error;
        }
    }
    getStatus() {
        return (0, database_1.getDatabaseStatus)();
    }
    isDatabaseConnected() {
        return this.isConnected;
    }
    async healthCheck() {
        try {
            return await (0, database_1.checkDatabaseHealth)();
        }
        catch (error) {
            logger_1.logger.error('Database health check failed:', error);
            return false;
        }
    }
    getConnection() {
        return mongoose_1.default.connection;
    }
    getMongoose() {
        return mongoose_1.default;
    }
}
exports.DatabaseManager = DatabaseManager;
exports.databaseManager = DatabaseManager.getInstance();
__exportStar(require("./utils"), exports);
