import mongoose from 'mongoose';
import { connectDatabase, disconnectDatabase, getDatabaseStatus, checkDatabaseHealth, gracefulShutdown } from '../config/database';
export declare class DatabaseManager {
    private static instance;
    private isConnected;
    private connectionPromise;
    private constructor();
    static getInstance(): DatabaseManager;
    private setupEventListeners;
    connect(): Promise<void>;
    private performConnection;
    disconnect(): Promise<void>;
    getStatus(): string;
    isDatabaseConnected(): boolean;
    healthCheck(): Promise<boolean>;
    getConnection(): mongoose.Connection;
    getMongoose(): typeof mongoose;
}
export declare const databaseManager: DatabaseManager;
export { connectDatabase, disconnectDatabase, getDatabaseStatus, checkDatabaseHealth, gracefulShutdown };
export * from './utils';
