import { databaseManager } from './index';
export declare const initializeDatabase: () => Promise<void>;
export declare const closeDatabase: () => Promise<void>;
export declare const getDatabaseStatus: () => string;
export declare const isDatabaseConnected: () => boolean;
export declare const performHealthCheck: () => Promise<boolean>;
export declare const testConnection: () => Promise<boolean>;
export declare const waitForDatabase: (maxAttempts?: number, delayMs?: number) => Promise<boolean>;
export declare const getDatabaseStats: () => Promise<Record<string, any>>;
export { databaseManager };
export declare const CONNECTION_STATUS: {
    readonly DISCONNECTED: "disconnected";
    readonly CONNECTED: "connected";
    readonly CONNECTING: "connecting";
    readonly DISCONNECTING: "disconnecting";
};
