"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.vtuBuySchema = exports.billPaySchema = exports.walletDebitSchema = exports.walletCreditSchema = exports.validate = void 0;
const zod_1 = require("zod");
const validate = (schema, target = 'body') => (req, res, next) => {
    try {
        const parsed = schema.parse(req[target]);
        req[target] = parsed;
        next();
    }
    catch (e) {
        if (e?.issues) {
            res.status(400).json({ error: 'Validation failed', details: e.issues.map((i) => ({ path: i.path, message: i.message })) });
        }
        else {
            res.status(400).json({ error: 'Validation failed' });
        }
    }
};
exports.validate = validate;
exports.walletCreditSchema = zod_1.z.object({
    amount: zod_1.z.number().positive(),
    currency: zod_1.z.enum(['NGN', 'USD']).default('NGN'),
    reference: zod_1.z.string().min(1),
    category: zod_1.z.enum(['funding', 'transfer', 'bill_payment', 'vtu', 'refund', 'fee', 'reversal']).default('funding'),
    description: zod_1.z.string().optional(),
    metadata: zod_1.z.record(zod_1.z.any()).optional(),
});
exports.walletDebitSchema = zod_1.z.object({
    amount: zod_1.z.number().positive(),
    currency: zod_1.z.enum(['NGN', 'USD']).default('NGN'),
    reference: zod_1.z.string().min(1),
    category: zod_1.z.enum(['funding', 'transfer', 'bill_payment', 'vtu', 'refund', 'fee', 'reversal']).default('transfer'),
    description: zod_1.z.string().optional(),
    metadata: zod_1.z.record(zod_1.z.any()).optional(),
});
exports.billPaySchema = zod_1.z.object({
    amount: zod_1.z.number().positive(),
    currency: zod_1.z.enum(['NGN', 'USD']).default('NGN'),
    reference: zod_1.z.string().min(1),
    type: zod_1.z.enum(['electricity', 'cable_tv', 'internet', 'exam_pin']),
    biller: zod_1.z.enum(['ikeja_electric', 'eko_electric', 'dstv', 'gotv', 'startimes', 'spectranet', 'smile', 'waec', 'neco', 'jamb', 'others']),
    customerId: zod_1.z.string().min(1),
    productCode: zod_1.z.string().optional(),
});
exports.vtuBuySchema = zod_1.z.object({
    amount: zod_1.z.number().positive(),
    currency: zod_1.z.enum(['NGN', 'USD']).default('NGN'),
    reference: zod_1.z.string().min(1),
    type: zod_1.z.enum(['airtime', 'data']),
    network: zod_1.z.enum(['mtn', 'airtel', 'glo', '9mobile']),
    phone: zod_1.z.string().min(7),
    planCode: zod_1.z.string().optional(),
});
