import { z, ZodSchema } from 'zod';
import { Request, Response, NextFunction } from 'express';
export declare const validate: <T>(schema: ZodSchema<T>, target?: "body" | "query" | "params") => (req: Request, res: Response, next: NextFunction) => void;
export declare const walletCreditSchema: z.ZodObject<{
    amount: z.ZodNumber;
    currency: z.ZodDefault<z.ZodEnum<["NGN", "USD"]>>;
    reference: z.ZodString;
    category: z.ZodDefault<z.ZodEnum<["funding", "transfer", "bill_payment", "vtu", "refund", "fee", "reversal"]>>;
    description: z.ZodOptional<z.ZodString>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
}, "strip", z.ZodTypeAny, {
    amount: number;
    currency: "NGN" | "USD";
    reference: string;
    category: "funding" | "transfer" | "bill_payment" | "vtu" | "refund" | "fee" | "reversal";
    description?: string | undefined;
    metadata?: Record<string, any> | undefined;
}, {
    amount: number;
    reference: string;
    description?: string | undefined;
    currency?: "NGN" | "USD" | undefined;
    category?: "funding" | "transfer" | "bill_payment" | "vtu" | "refund" | "fee" | "reversal" | undefined;
    metadata?: Record<string, any> | undefined;
}>;
export declare const walletDebitSchema: z.ZodObject<{
    amount: z.ZodNumber;
    currency: z.ZodDefault<z.ZodEnum<["NGN", "USD"]>>;
    reference: z.ZodString;
    category: z.ZodDefault<z.ZodEnum<["funding", "transfer", "bill_payment", "vtu", "refund", "fee", "reversal"]>>;
    description: z.ZodOptional<z.ZodString>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
}, "strip", z.ZodTypeAny, {
    amount: number;
    currency: "NGN" | "USD";
    reference: string;
    category: "funding" | "transfer" | "bill_payment" | "vtu" | "refund" | "fee" | "reversal";
    description?: string | undefined;
    metadata?: Record<string, any> | undefined;
}, {
    amount: number;
    reference: string;
    description?: string | undefined;
    currency?: "NGN" | "USD" | undefined;
    category?: "funding" | "transfer" | "bill_payment" | "vtu" | "refund" | "fee" | "reversal" | undefined;
    metadata?: Record<string, any> | undefined;
}>;
export declare const billPaySchema: z.ZodObject<{
    amount: z.ZodNumber;
    currency: z.ZodDefault<z.ZodEnum<["NGN", "USD"]>>;
    reference: z.ZodString;
    type: z.ZodEnum<["electricity", "cable_tv", "internet", "exam_pin"]>;
    biller: z.ZodEnum<["ikeja_electric", "eko_electric", "dstv", "gotv", "startimes", "spectranet", "smile", "waec", "neco", "jamb", "others"]>;
    customerId: z.ZodString;
    productCode: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "electricity" | "cable_tv" | "internet" | "exam_pin";
    amount: number;
    currency: "NGN" | "USD";
    reference: string;
    biller: "ikeja_electric" | "eko_electric" | "dstv" | "gotv" | "startimes" | "spectranet" | "smile" | "waec" | "neco" | "jamb" | "others";
    customerId: string;
    productCode?: string | undefined;
}, {
    type: "electricity" | "cable_tv" | "internet" | "exam_pin";
    amount: number;
    reference: string;
    biller: "ikeja_electric" | "eko_electric" | "dstv" | "gotv" | "startimes" | "spectranet" | "smile" | "waec" | "neco" | "jamb" | "others";
    customerId: string;
    currency?: "NGN" | "USD" | undefined;
    productCode?: string | undefined;
}>;
export declare const vtuBuySchema: z.ZodObject<{
    amount: z.ZodNumber;
    currency: z.ZodDefault<z.ZodEnum<["NGN", "USD"]>>;
    reference: z.ZodString;
    type: z.ZodEnum<["airtime", "data"]>;
    network: z.ZodEnum<["mtn", "airtel", "glo", "9mobile"]>;
    phone: z.ZodString;
    planCode: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "data" | "airtime";
    phone: string;
    amount: number;
    currency: "NGN" | "USD";
    reference: string;
    network: "mtn" | "airtel" | "glo" | "9mobile";
    planCode?: string | undefined;
}, {
    type: "data" | "airtime";
    phone: string;
    amount: number;
    reference: string;
    network: "mtn" | "airtel" | "glo" | "9mobile";
    currency?: "NGN" | "USD" | undefined;
    planCode?: string | undefined;
}>;
