import cors from 'cors';
export declare const strictCorsOptions: cors.CorsOptions;
export declare const getCSPPolicy: (environment: string) => {
    'default-src': string[];
    'script-src': string[];
    'style-src': string[];
    'img-src': string[];
    'connect-src': string[];
    'font-src': string[];
    'object-src': string[];
    'media-src': string[];
    'frame-src': string[];
    'frame-ancestors': string[];
    'form-action': string[];
    'base-uri': string[];
    'manifest-src': string[];
    'worker-src': string[];
    'child-src': string[];
    'upgrade-insecure-requests': never[];
};
export declare const enhancedHelmetOptions: {
    contentSecurityPolicy: {
        directives: {
            'default-src': string[];
            'script-src': string[];
            'style-src': string[];
            'img-src': string[];
            'connect-src': string[];
            'font-src': string[];
            'object-src': string[];
            'media-src': string[];
            'frame-src': string[];
            'frame-ancestors': string[];
            'form-action': string[];
            'base-uri': string[];
            'manifest-src': string[];
            'worker-src': string[];
            'child-src': string[];
            'upgrade-insecure-requests': never[];
        };
        reportOnly: boolean;
    };
    crossOriginEmbedderPolicy: {
        policy: "require-corp";
    };
    crossOriginOpenerPolicy: {
        policy: "same-origin";
    };
    crossOriginResourcePolicy: {
        policy: "same-site";
    };
    dnsPrefetchControl: {
        allow: boolean;
    };
    frameguard: {
        action: "deny";
    };
    hidePoweredBy: boolean;
    hsts: {
        maxAge: number;
        includeSubDomains: boolean;
        preload: boolean;
    };
    ieNoOpen: boolean;
    noSniff: boolean;
    permittedCrossDomainPolicies: {
        permittedPolicies: "none";
    };
    referrerPolicy: {
        policy: "strict-origin-when-cross-origin";
    };
    xssFilter: boolean;
};
export declare const hppOptions: {
    whitelist: string[];
    checkBody: boolean;
    checkBodyOnlyForContentTypes: string[];
    checkQuery: boolean;
    checkQueryOnlyForContentTypes: string[];
};
export declare const securityHeaders: {
    'X-Content-Type-Options': string;
    'X-Frame-Options': string;
    'X-XSS-Protection': string;
    'Referrer-Policy': string;
    'Permissions-Policy': string;
    'Strict-Transport-Security': string;
    'X-DNS-Prefetch-Control': string;
    'X-Download-Options': string;
    'X-Permitted-Cross-Domain-Policies': string;
    'X-Robots-Tag': string;
    'X-Request-ID': string;
    'X-Correlation-ID': string;
};
export declare const createSecurityMiddleware: () => {
    helmet: (req: import("http").IncomingMessage, res: import("http").ServerResponse, next: (err?: unknown) => void) => void;
    cors: (req: cors.CorsRequest, res: {
        statusCode?: number | undefined;
        setHeader(key: string, value: string): any;
        end(): any;
    }, next: (err?: any) => any) => void;
    hpp: import("express").RequestHandler<import("express-serve-static-core").ParamsDictionary, any, any, import("qs").ParsedQs, Record<string, any>>;
};
export declare const securityUtils: {
    validateApiKey: (apiKey: string) => boolean;
    validateJWTFormat: (token: string) => boolean;
    sanitizeInput: (input: string) => string;
    validateFileType: (mimeType: string, allowedTypes: string[]) => boolean;
    validateFileSize: (size: number, maxSize: number) => boolean;
    generateSecureRandom: (length?: number) => string;
    validatePasswordStrength: (password: string) => {
        isValid: boolean;
        errors: string[];
    };
};
export declare const securityMonitoring: {
    trackSecurityEvent: (event: string, details: any) => void;
    trackFailedAuth: (ip: string, userAgent: string, reason: string) => void;
    trackSuspiciousActivity: (ip: string, activity: string, details: any) => void;
};
declare const _default: {
    strictCorsOptions: cors.CorsOptions;
    enhancedHelmetOptions: {
        contentSecurityPolicy: {
            directives: {
                'default-src': string[];
                'script-src': string[];
                'style-src': string[];
                'img-src': string[];
                'connect-src': string[];
                'font-src': string[];
                'object-src': string[];
                'media-src': string[];
                'frame-src': string[];
                'frame-ancestors': string[];
                'form-action': string[];
                'base-uri': string[];
                'manifest-src': string[];
                'worker-src': string[];
                'child-src': string[];
                'upgrade-insecure-requests': never[];
            };
            reportOnly: boolean;
        };
        crossOriginEmbedderPolicy: {
            policy: "require-corp";
        };
        crossOriginOpenerPolicy: {
            policy: "same-origin";
        };
        crossOriginResourcePolicy: {
            policy: "same-site";
        };
        dnsPrefetchControl: {
            allow: boolean;
        };
        frameguard: {
            action: "deny";
        };
        hidePoweredBy: boolean;
        hsts: {
            maxAge: number;
            includeSubDomains: boolean;
            preload: boolean;
        };
        ieNoOpen: boolean;
        noSniff: boolean;
        permittedCrossDomainPolicies: {
            permittedPolicies: "none";
        };
        referrerPolicy: {
            policy: "strict-origin-when-cross-origin";
        };
        xssFilter: boolean;
    };
    hppOptions: {
        whitelist: string[];
        checkBody: boolean;
        checkBodyOnlyForContentTypes: string[];
        checkQuery: boolean;
        checkQueryOnlyForContentTypes: string[];
    };
    securityHeaders: {
        'X-Content-Type-Options': string;
        'X-Frame-Options': string;
        'X-XSS-Protection': string;
        'Referrer-Policy': string;
        'Permissions-Policy': string;
        'Strict-Transport-Security': string;
        'X-DNS-Prefetch-Control': string;
        'X-Download-Options': string;
        'X-Permitted-Cross-Domain-Policies': string;
        'X-Robots-Tag': string;
        'X-Request-ID': string;
        'X-Correlation-ID': string;
    };
    createSecurityMiddleware: () => {
        helmet: (req: import("http").IncomingMessage, res: import("http").ServerResponse, next: (err?: unknown) => void) => void;
        cors: (req: cors.CorsRequest, res: {
            statusCode?: number | undefined;
            setHeader(key: string, value: string): any;
            end(): any;
        }, next: (err?: any) => any) => void;
        hpp: import("express").RequestHandler<import("express-serve-static-core").ParamsDictionary, any, any, import("qs").ParsedQs, Record<string, any>>;
    };
    securityUtils: {
        validateApiKey: (apiKey: string) => boolean;
        validateJWTFormat: (token: string) => boolean;
        sanitizeInput: (input: string) => string;
        validateFileType: (mimeType: string, allowedTypes: string[]) => boolean;
        validateFileSize: (size: number, maxSize: number) => boolean;
        generateSecureRandom: (length?: number) => string;
        validatePasswordStrength: (password: string) => {
            isValid: boolean;
            errors: string[];
        };
    };
    securityMonitoring: {
        trackSecurityEvent: (event: string, details: any) => void;
        trackFailedAuth: (ip: string, userAgent: string, reason: string) => void;
        trackSuspiciousActivity: (ip: string, activity: string, details: any) => void;
    };
};
export default _default;
