export interface Secret {
    id: string;
    name: string;
    value: string;
    encryptedValue: string;
    type: 'api_key' | 'jwt_secret' | 'database_password' | 'encryption_key' | 'webhook_secret';
    environment: 'development' | 'production' | 'test';
    createdAt: Date;
    updatedAt: Date;
    expiresAt?: Date;
    rotationPeriod: number;
    lastRotated: Date;
    version: number;
    isActive: boolean;
}
export declare class EncryptionManager {
    private static instance;
    private masterKey;
    private constructor();
    static getInstance(): EncryptionManager;
    encrypt(value: string): string;
    decrypt(encryptedValue: string): string;
    generateSecret(length?: number): string;
}
export declare class SecretsManager {
    private static instance;
    private encryptionManager;
    private secrets;
    private constructor();
    static getInstance(): SecretsManager;
    createSecret(name: string, value: string, type: Secret['type'], environment?: Secret['environment'], rotationPeriod?: number): Promise<Secret>;
    getSecret(name: string, environment?: string): Promise<Secret | null>;
    getSecretValue(name: string, environment?: string): Promise<string | null>;
    rotateSecret(name: string, environment?: string): Promise<Secret>;
    checkRotationNeeded(name: string, environment?: string): Promise<boolean>;
    rotateExpiredSecrets(): Promise<string[]>;
    deactivateSecret(name: string, environment?: string): Promise<void>;
    listSecrets(environment?: string): Promise<Secret[]>;
    private storeSecretInRedis;
    private getSecretFromRedis;
    initializeDefaultSecrets(): Promise<void>;
}
export declare class KeyRotationScheduler {
    private static instance;
    private secretsManager;
    private intervalId?;
    private constructor();
    static getInstance(): KeyRotationScheduler;
    startRotationSchedule(checkIntervalHours?: number): void;
    stopRotationSchedule(): void;
    checkAndRotate(): Promise<string[]>;
}
export declare const secretsManager: SecretsManager;
export declare const keyRotationScheduler: KeyRotationScheduler;
export declare const encryptionManager: EncryptionManager;
export declare const getSecret: (name: string, environment?: string) => Promise<string | null>;
export declare const createSecret: (name: string, value: string, type: Secret["type"], environment?: Secret["environment"], rotationPeriod?: number) => Promise<Secret>;
export declare const rotateSecret: (name: string, environment?: string) => Promise<Secret>;
