export declare class FieldEncryption {
    private static readonly ALGORITHM;
    private static readonly IV_LENGTH;
    private static readonly TAG_LENGTH;
    private static readonly SALT_LENGTH;
    private static encryptionKey;
    private static getEncryptionKey;
    static encrypt(plaintext: string): string;
    static decrypt(encryptedValue: string): string;
    static isEncrypted(value: string): boolean;
    static encryptFields<T extends Record<string, any>>(obj: T, fieldsToEncrypt: (keyof T)[]): T;
    static decryptFields<T extends Record<string, any>>(obj: T, fieldsToDecrypt: (keyof T)[]): T;
    static createSearchHash(value: string): string;
    static verifyEncryptedField(plainValue: string, encryptedValue: string): boolean;
}
export declare function encryptedFieldsPlugin(schema: any, options: {
    fields: string[];
}): void;
export default FieldEncryption;
