"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.webhookRawBodyMiddleware = void 0;
const webhookRawBodyMiddleware = (req, res, next) => {
    if (req.path.includes('/webhooks/')) {
        console.log(`[RawBody] Capturing raw body for webhook: ${req.path}`);
        let data = '';
        let chunks = [];
        req.on('data', (chunk) => {
            chunks.push(chunk);
            data += chunk.toString('utf8');
        });
        req.on('end', () => {
            req.rawBody = data;
            req.rawBodyBuffer = Buffer.concat(chunks);
            console.log(`[RawBody] Captured ${data.length} characters for webhook`);
            if (data.length === 0) {
                console.warn(`[RawBody] Warning: Empty raw body captured for ${req.path}`);
            }
            next();
        });
        req.on('error', (error) => {
            console.error(`[RawBody] Error reading request body for ${req.path}:`, error);
            next(error);
        });
        if (req.rawBody) {
            console.log(`[RawBody] Raw body already exists for ${req.path}, skipping capture`);
            next();
        }
    }
    else {
        next();
    }
};
exports.webhookRawBodyMiddleware = webhookRawBodyMiddleware;
