import { Request, Response, NextFunction } from 'express';
export interface RequestContext {
    requestId: string;
    startTime: number;
    method: string;
    url: string;
    userAgent?: string;
    ip: string;
    userId?: string;
    correlationId?: string;
}
declare global {
    namespace Express {
        interface Request {
            context?: RequestContext;
        }
    }
}
export declare class RequestLifecycleMiddleware {
    private static instance;
    private constructor();
    static getInstance(): RequestLifecycleMiddleware;
    initializeContext: (req: Request, res: Response, next: NextFunction) => void;
    logRequest: (req: Request, _res: Response, next: NextFunction) => void;
    logResponse: (req: Request, res: Response, next: NextFunction) => void;
    private performanceMetrics;
    getPerformanceMetrics(): Record<string, any>;
    validateRequest: (schema?: any) => (req: Request, res: Response, next: NextFunction) => void | Response<any, Record<string, any>>;
    private validateAgainstSchema;
    securityHeaders: (_req: Request, res: Response, next: NextFunction) => void;
    sanitizeRequest: (req: Request, _res: Response, next: NextFunction) => void;
    private sanitizeData;
    timeout: (timeoutMs?: number) => (req: Request, res: Response, next: NextFunction) => void;
    sizeLimit: (limit?: string) => (req: Request, res: Response, next: NextFunction) => void;
    private parseSizeLimit;
}
export declare const requestLifecycle: RequestLifecycleMiddleware;
export declare const initializeContext: (req: Request, res: Response, next: NextFunction) => void, logRequest: (req: Request, _res: Response, next: NextFunction) => void, logResponse: (req: Request, res: Response, next: NextFunction) => void, validateRequest: (schema?: any) => (req: Request, res: Response, next: NextFunction) => void | Response<any, Record<string, any>>, securityHeaders: (_req: Request, res: Response, next: NextFunction) => void, sanitizeRequest: (req: Request, _res: Response, next: NextFunction) => void, timeout: (timeoutMs?: number) => (req: Request, res: Response, next: NextFunction) => void, sizeLimit: (limit?: string) => (req: Request, res: Response, next: NextFunction) => void, getPerformanceMetrics: () => Record<string, any>;
