import { Request, Response, NextFunction } from 'express';
export interface CacheConfig {
    ttl: number;
    key?: string;
    condition?: (req: Request, res: Response) => boolean;
    invalidate?: string[];
}
export declare class CacheKeyGenerator {
    static generateKey(req: Request, customKey?: string): string;
    static generateUserKey(userId: string, prefix: string): string;
    static generateServiceKey(service: string, operation: string, params: any): string;
}
export declare const cacheMiddleware: (config: CacheConfig) => (req: Request, res: Response, next: NextFunction) => Promise<void | Response<any, Record<string, any>>>;
export declare const cacheInvalidation: (patterns: string[]) => (req: Request, res: Response, next: NextFunction) => Promise<void>;
export declare const cacheService: (config: CacheConfig) => (target: any, propertyName: string, descriptor: PropertyDescriptor) => void;
export declare class QueryCache {
    private static instance;
    private constructor();
    static getInstance(): QueryCache;
    get<T>(key: string): Promise<T | null>;
    set<T>(key: string, value: T, ttl?: number): Promise<void>;
    invalidate(pattern: string): Promise<void>;
    generateKey(collection: string, query: any, options?: any): string;
}
export declare const queryCache: QueryCache;
export declare class CacheWarmer {
    private static instance;
    private constructor();
    static getInstance(): CacheWarmer;
    warmCache(patterns: string[], _ttl?: number): Promise<void>;
    preloadUserData(userId: string, dataTypes: string[]): Promise<void>;
}
export declare const cacheWarmer: CacheWarmer;
export declare class CacheStats {
    private static instance;
    private stats;
    private constructor();
    static getInstance(): CacheStats;
    recordHit(key: string): void;
    recordMiss(key: string): void;
    recordError(key: string): void;
    getStats(): Record<string, any>;
    resetStats(): void;
}
export declare const cacheStats: CacheStats;
export declare const cacheConfigs: {
    short: {
        ttl: number;
    };
    medium: {
        ttl: number;
    };
    long: {
        ttl: number;
    };
    user: {
        ttl: number;
    };
    static: {
        ttl: number;
    };
};
export declare const shortCache: (key?: string) => (req: Request, res: Response, next: NextFunction) => Promise<void | Response<any, Record<string, any>>>;
export declare const mediumCache: (key?: string) => (req: Request, res: Response, next: NextFunction) => Promise<void | Response<any, Record<string, any>>>;
export declare const longCache: (key?: string) => (req: Request, res: Response, next: NextFunction) => Promise<void | Response<any, Record<string, any>>>;
export declare const userCache: (key?: string) => (req: Request, res: Response, next: NextFunction) => Promise<void | Response<any, Record<string, any>>>;
export declare const staticCache: (key?: string) => (req: Request, res: Response, next: NextFunction) => Promise<void | Response<any, Record<string, any>>>;
