"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.requireRole = exports.requireAuth = void 0;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const env_1 = require("../../config/env");
const requireAuth = (req, res, next) => {
    const header = req.headers['authorization'];
    let token = null;
    if (header && header.startsWith('Bearer ')) {
        token = header.slice('Bearer '.length);
    }
    else {
        const qToken = req.query['token'] || req.query['access_token'];
        if (qToken && typeof qToken === 'string' && qToken.length > 0) {
            token = qToken;
        }
    }
    if (token) {
        try {
            token = decodeURIComponent(token);
        }
        catch { }
    }
    if (!token) {
        res.status(401).json({ error: 'Unauthorized' });
        return;
    }
    try {
        const decoded = jsonwebtoken_1.default.verify(token, env_1.env.JWT_SECRET);
        const userId = decoded['userId'];
        const role = decoded['role'];
        if (!userId) {
            res.status(401).json({ error: 'Unauthorized' });
            return;
        }
        req.user = { userId, ...(role !== undefined && { role }) };
        next();
    }
    catch (_e) {
        res.status(401).json({ error: 'Unauthorized' });
    }
};
exports.requireAuth = requireAuth;
const requireRole = (role) => (req, res, next) => {
    if (!req.user) {
        res.status(401).json({ error: 'Unauthorized' });
        return;
    }
    if (role === 'user') {
        next();
        return;
    }
    if (req.user.role === 'admin') {
        next();
        return;
    }
    res.status(403).json({ error: 'Forbidden' });
};
exports.requireRole = requireRole;
