import { Request, Response, NextFunction } from 'express';
export declare class AppError extends Error {
    readonly statusCode: number;
    readonly isOperational: boolean;
    readonly code?: string;
    readonly details?: any;
    constructor(message: string, statusCode?: number, isOperational?: boolean, code?: string, details?: any);
}
export declare class ValidationError extends AppError {
    constructor(message: string, details?: any);
}
export declare class BadRequestError extends AppError {
    constructor(message: string, code?: string, details?: any);
}
export declare class AuthenticationError extends AppError {
    constructor(message?: string);
}
export declare class AuthorizationError extends AppError {
    constructor(message?: string);
}
export declare class NotFoundError extends AppError {
    constructor(message?: string);
}
export declare class ConflictError extends AppError {
    constructor(message?: string);
}
export declare class RateLimitError extends AppError {
    constructor(message?: string);
}
export declare class DatabaseError extends AppError {
    constructor(message?: string);
}
export declare class ExternalServiceError extends AppError {
    constructor(message?: string);
}
export interface ErrorLogger {
    error(error: Error, context?: any): void;
    warn(message: string, context?: any): void;
    info(message: string, context?: any): void;
}
export declare class ConsoleErrorLogger implements ErrorLogger {
    error(error: Error, context?: any): void;
    warn(message: string, context?: any): void;
    info(message: string, context?: any): void;
}
export declare const errorHandler: (logger?: ErrorLogger) => (err: Error | AppError, req: Request, res: Response, _next: NextFunction) => void;
export declare const asyncHandler: (fn: Function) => (req: Request, res: Response, next: NextFunction) => void;
export declare const requestIdMiddleware: (req: Request, res: Response, next: NextFunction) => void;
export declare class ErrorMonitor {
    private static instance;
    private errorCounts;
    private alertThreshold;
    static getInstance(): ErrorMonitor;
    trackError(error: AppError): void;
    private sendAlert;
    getErrorStats(): Record<string, number>;
    resetCounts(): void;
}
export declare const errorMonitor: ErrorMonitor;
