export interface BackupConfig {
    id: string;
    name: string;
    type: 'full' | 'incremental' | 'differential';
    source: 'database' | 'files' | 'redis' | 'secrets' | 'logs';
    schedule: 'hourly' | 'daily' | 'weekly' | 'monthly' | 'manual';
    retention: number;
    compression: boolean;
    encryption: boolean;
    destination: 'local' | 's3' | 'gcs' | 'azure';
    enabled: boolean;
}
export interface BackupMetadata {
    id: string;
    configId: string;
    timestamp: Date;
    size: number;
    checksum: string;
    status: 'pending' | 'in_progress' | 'completed' | 'failed';
    error?: string;
    duration: number;
    files: string[];
    encryptionKey?: string;
}
export interface RestoreConfig {
    backupId: string;
    destination: string;
    validateOnly: boolean;
    overwrite: boolean;
    pointInTime?: Date;
}
export interface DRRunbook {
    id: string;
    name: string;
    description: string;
    severity: 'low' | 'medium' | 'high' | 'critical';
    steps: DRStep[];
    estimatedTime: number;
    dependencies: string[];
    contacts: string[];
}
export interface DRStep {
    id: string;
    name: string;
    description: string;
    command?: string;
    script?: string;
    manual?: boolean;
    order: number;
    timeout: number;
    rollback?: string;
}
export declare class BackupManager {
    private static instance;
    private backupConfigs;
    private backupHistory;
    private drRunbooks;
    private constructor();
    static getInstance(): BackupManager;
    private initializeBackupConfigs;
    private initializeDRRunbooks;
    createBackup(configId: string): Promise<BackupMetadata>;
    private backupDatabase;
    private backupRedis;
    private backupSecrets;
    private backupLogs;
    restoreFromBackup(backupId: string, config: RestoreConfig): Promise<void>;
    private restoreDatabase;
    private restoreRedis;
    private restoreSecrets;
    private restoreLogs;
    executeDRRunbook(runbookId: string): Promise<void>;
    listBackups(configId?: string): Promise<BackupMetadata[]>;
    getBackupMetadata(backupId: string): Promise<BackupMetadata | null>;
    private storeBackupMetadata;
    cleanupOldBackups(): Promise<string[]>;
    getDRRunbooks(): DRRunbook[];
    getDRRunbook(runbookId: string): DRRunbook | null;
}
export declare const backupManager: BackupManager;
export declare const createBackup: (configId: string) => Promise<BackupMetadata>;
export declare const restoreBackup: (backupId: string, config: RestoreConfig) => Promise<void>;
export declare const executeDRRunbook: (runbookId: string) => Promise<void>;
export declare const listBackups: (configId?: string) => Promise<BackupMetadata[]>;
export declare const cleanupBackups: () => Promise<string[]>;
