export interface PIIField {
    field: string;
    type: 'email' | 'phone' | 'bvn' | 'nin' | 'address' | 'bank_account' | 'card_number' | 'id_number';
    sensitivity: 'high' | 'medium' | 'low';
    encryption: boolean;
    masking: boolean;
    retention: number;
}
export declare enum DataClassification {
    PUBLIC = "public",
    INTERNAL = "internal",
    CONFIDENTIAL = "confidential",
    RESTRICTED = "restricted"
}
export interface ComplianceRequirement {
    id: string;
    name: string;
    description: string;
    regulation: 'NDPR' | 'CBN' | 'GDPR' | 'PCI_DSS';
    category: 'data_protection' | 'privacy' | 'security' | 'retention' | 'consent';
    status: 'compliant' | 'non_compliant' | 'in_progress' | 'not_applicable';
    lastAudit: Date;
    nextAudit: Date;
    requirements: string[];
}
export interface RetentionPolicy {
    dataType: string;
    retentionPeriod: number;
    disposalMethod: 'delete' | 'archive' | 'anonymize';
    legalBasis: string;
    exceptions: string[];
}
export interface ConsentRecord {
    id: string;
    userId: string;
    purpose: string;
    consentType: 'explicit' | 'implicit' | 'withdrawn';
    grantedAt: Date;
    withdrawnAt?: Date;
    expiresAt?: Date;
    dataUsage: string[];
    version: string;
}
export interface DLPRule {
    id: string;
    name: string;
    pattern: RegExp;
    action: 'block' | 'log' | 'encrypt' | 'mask';
    severity: 'low' | 'medium' | 'high' | 'critical';
    description: string;
    enabled: boolean;
}
export declare class ComplianceManager {
    private static instance;
    private piiFields;
    private retentionPolicies;
    private dlpRules;
    private consentRecords;
    private constructor();
    static getInstance(): ComplianceManager;
    private initializePIIFields;
    private initializeRetentionPolicies;
    private initializeDLPRules;
    detectAndProcessPII(data: any): any;
    private processPIIField;
    private encryptPII;
    private maskPII;
    scanForSensitiveData(content: string): DLPRule[];
    applyDLPActions(content: string, rules: DLPRule[]): string;
    private logDLPEvent;
    recordConsent(userId: string, purpose: string, consentType: ConsentRecord['consentType'], dataUsage: string[], expiresAt?: Date): Promise<ConsentRecord>;
    withdrawConsent(userId: string, purpose: string): Promise<void>;
    hasValidConsent(userId: string, purpose: string): Promise<boolean>;
    checkRetentionCompliance(dataType: string, createdAt: Date): Promise<{
        compliant: boolean;
        daysUntilDisposal: number;
        disposalMethod: string;
    }>;
    disposeData(dataType: string, _data: any): Promise<void>;
    generateComplianceReport(): Promise<{
        ndprCompliance: boolean;
        cbnCompliance: boolean;
        piiProtection: boolean;
        retentionCompliance: boolean;
        consentCompliance: boolean;
        details: any;
    }>;
    private storeConsentInRedis;
}
export declare const complianceManager: ComplianceManager;
export declare const detectPII: (data: any) => any;
export declare const scanDLP: (content: string) => DLPRule[];
export declare const recordConsent: (userId: string, purpose: string, consentType: ConsentRecord["consentType"], dataUsage: string[], expiresAt?: Date) => Promise<ConsentRecord>;
export declare const checkConsent: (userId: string, purpose: string) => Promise<boolean>;
export declare const generateComplianceReport: () => Promise<{
    ndprCompliance: boolean;
    cbnCompliance: boolean;
    piiProtection: boolean;
    retentionCompliance: boolean;
    consentCompliance: boolean;
    details: any;
}>;
