import cors from 'cors';
export declare const corsOptions: cors.CorsOptions;
export declare const helmetOptions: any;
export declare const securityConfig: {
    trustProxy: boolean;
    maxRequestSize: number;
    uploadSecurity: {
        allowedMimeTypes: string[];
        maxFileSize: number;
        uploadPath: string;
    };
    sessionSecurity: {
        secure: boolean;
        httpOnly: boolean;
        sameSite: "strict";
        maxAge: number;
    };
    passwordSecurity: {
        minLength: number;
        requireUppercase: boolean;
        requireLowercase: boolean;
        requireNumbers: boolean;
        requireSpecialChars: boolean;
        bcryptRounds: number;
    };
    jwtSecurity: {
        secret: string;
        expiresIn: string;
        refreshExpiresIn: string;
        issuer: string;
        audience: string;
    };
    apiSecurity: {
        requireApiKey: boolean;
        apiKeyHeader: string;
        rateLimitEnabled: boolean;
        requestLogging: boolean;
        errorLogging: boolean;
    };
    compliance: {
        ndpr: boolean;
        cbn: boolean;
        dataRetentionDays: number;
        auditLogging: boolean;
        dataEncryption: boolean;
    };
};
export declare const securityHeaders: {
    'X-Content-Type-Options': string;
    'X-Frame-Options': string;
    'X-XSS-Protection': string;
    'Referrer-Policy': string;
    'Permissions-Policy': string;
    'Strict-Transport-Security': string;
};
export declare const getCSPPolicy: (environment: string) => {
    'default-src': string[];
    'script-src': string[];
    'style-src': string[];
    'img-src': string[];
    'connect-src': string[];
    'font-src': string[];
    'object-src': string[];
    'media-src': string[];
    'frame-src': string[];
};
export declare const createSecurityMiddleware: () => {
    helmet: (req: import("http").IncomingMessage, res: import("http").ServerResponse, next: (err?: unknown) => void) => void;
    cors: (req: cors.CorsRequest, res: {
        statusCode?: number | undefined;
        setHeader(key: string, value: string): any;
        end(): any;
    }, next: (err?: any) => any) => void;
    trustProxy: (req: any, _res: any, next: any) => void;
};
