import { RedisClientOptions } from 'redis';
export declare const connectionOptions: RedisClientOptions<import("redis").RedisModules, import("redis").RedisFunctions, import("redis").RedisScripts> | null;
export declare const redisConfig: RedisClientOptions;
export declare const bullConnectionOptions: any;
export declare const redisConfigs: {
    main: {
        database: number;
        url?: string;
        socket?: import("@redis/client/dist/lib/client/socket").RedisSocketOptions;
        username?: string;
        password?: string;
        name?: string;
        commandsQueueMaxLength?: number;
        disableOfflineQueue?: boolean;
        readonly?: boolean;
        legacyMode?: boolean;
        isolationPoolOptions?: import("generic-pool").Options;
        pingInterval?: number;
        disableClientInfo?: boolean;
        clientInfoTag?: string;
        modules?: import("redis").RedisModules | undefined;
        functions?: import("redis").RedisFunctions | undefined;
        scripts?: import("redis").RedisScripts | undefined;
    };
    jobs: {
        database: number;
        url?: string;
        socket?: import("@redis/client/dist/lib/client/socket").RedisSocketOptions;
        username?: string;
        password?: string;
        name?: string;
        commandsQueueMaxLength?: number;
        disableOfflineQueue?: boolean;
        readonly?: boolean;
        legacyMode?: boolean;
        isolationPoolOptions?: import("generic-pool").Options;
        pingInterval?: number;
        disableClientInfo?: boolean;
        clientInfoTag?: string;
        modules?: import("redis").RedisModules | undefined;
        functions?: import("redis").RedisFunctions | undefined;
        scripts?: import("redis").RedisScripts | undefined;
    };
    cache: {
        database: number;
        url?: string;
        socket?: import("@redis/client/dist/lib/client/socket").RedisSocketOptions;
        username?: string;
        password?: string;
        name?: string;
        commandsQueueMaxLength?: number;
        disableOfflineQueue?: boolean;
        readonly?: boolean;
        legacyMode?: boolean;
        isolationPoolOptions?: import("generic-pool").Options;
        pingInterval?: number;
        disableClientInfo?: boolean;
        clientInfoTag?: string;
        modules?: import("redis").RedisModules | undefined;
        functions?: import("redis").RedisFunctions | undefined;
        scripts?: import("redis").RedisScripts | undefined;
    };
    sessions: {
        database: number;
        url?: string;
        socket?: import("@redis/client/dist/lib/client/socket").RedisSocketOptions;
        username?: string;
        password?: string;
        name?: string;
        commandsQueueMaxLength?: number;
        disableOfflineQueue?: boolean;
        readonly?: boolean;
        legacyMode?: boolean;
        isolationPoolOptions?: import("generic-pool").Options;
        pingInterval?: number;
        disableClientInfo?: boolean;
        clientInfoTag?: string;
        modules?: import("redis").RedisModules | undefined;
        functions?: import("redis").RedisFunctions | undefined;
        scripts?: import("redis").RedisScripts | undefined;
    };
    rateLimit: {
        database: number;
        url?: string;
        socket?: import("@redis/client/dist/lib/client/socket").RedisSocketOptions;
        username?: string;
        password?: string;
        name?: string;
        commandsQueueMaxLength?: number;
        disableOfflineQueue?: boolean;
        readonly?: boolean;
        legacyMode?: boolean;
        isolationPoolOptions?: import("generic-pool").Options;
        pingInterval?: number;
        disableClientInfo?: boolean;
        clientInfoTag?: string;
        modules?: import("redis").RedisModules | undefined;
        functions?: import("redis").RedisFunctions | undefined;
        scripts?: import("redis").RedisScripts | undefined;
    };
};
export declare class RedisManager {
    private static instance;
    private clients;
    private fallbackClients;
    private isRedisAvailable;
    private connectionAttempted;
    private sharedConnection;
    private connectionCount;
    private maxConnections;
    private constructor();
    static getInstance(): RedisManager;
    private shouldUseFallback;
    getClient(type?: keyof typeof redisConfigs): Promise<any>;
    closeAll(): Promise<void>;
    healthCheck(): Promise<boolean>;
    getConnectionInfo(type?: keyof typeof redisConfigs): Promise<any>;
    isUsingFallback(): boolean;
    get(key: string): Promise<string | null>;
    setex(key: string, ttl: number, value: string): Promise<void>;
    keys(pattern: string): Promise<string[]>;
}
export declare const redisManager: RedisManager;
export declare const redisHelpers: {
    setWithExpiry(key: string, value: string, ttl: number): Promise<void>;
    get(key: string): Promise<any>;
    del(key: string): Promise<any>;
    exists(key: string): Promise<any>;
    expire(key: string, ttl: number): Promise<any>;
    ttl(key: string): Promise<any>;
    incr(key: string): Promise<any>;
    decr(key: string): Promise<any>;
    set(key: string, value: string): Promise<void>;
    keys(pattern: string): Promise<any>;
};
export declare const gracefulRedisShutdown: (signal: string) => Promise<void>;
