"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.redisOptionalManager = exports.RedisOptionalManager = void 0;
const env_1 = require("./env");
class RedisOptionalManager {
    static instance;
    isRedisAvailable = false;
    constructor() {
        this.checkRedisAvailability();
    }
    static getInstance() {
        if (!RedisOptionalManager.instance) {
            RedisOptionalManager.instance = new RedisOptionalManager();
        }
        return RedisOptionalManager.instance;
    }
    async checkRedisAvailability() {
        try {
            if (env_1.env.REDIS_OPTIONAL) {
                this.isRedisAvailable = false;
                console.log('📝 Redis disabled (REDIS_OPTIONAL=true) - using fallback for queues and caching');
                return;
            }
            this.isRedisAvailable = !!env_1.env.REDIS_URL;
            if (!this.isRedisAvailable) {
                console.log('📝 Redis disabled (no REDIS_URL provided) - using fallback for queues and caching');
            }
        }
        catch (error) {
            console.warn('⚠️ Redis not available, using fallback mode');
            this.isRedisAvailable = false;
        }
    }
    isAvailable() {
        return this.isRedisAvailable;
    }
    shouldUseRedis() {
        return this.isRedisAvailable && env_1.env.REDIS_OPTIONAL !== false;
    }
}
exports.RedisOptionalManager = RedisOptionalManager;
exports.redisOptionalManager = RedisOptionalManager.getInstance();
