import { Queue, Worker, Job } from 'bullmq';
import { QueueJob as FallbackQueueJob } from './queue-fallback';
export declare const QUEUE_NAMES: {
    readonly RECONCILIATION: "reconciliation";
    readonly CLEANUP: "cleanup";
    readonly REPORTS: "reports";
    readonly DISPUTE_ESCALATION: "dispute-escalation";
    readonly NOTIFICATIONS: "notifications";
    readonly DATA_RETENTION: "data-retention";
};
export declare const JOB_TYPES: {
    readonly DAILY_RECONCILIATION: "daily-reconciliation";
    readonly PROVIDER_RECONCILIATION: "provider-reconciliation";
    readonly OLD_TRANSACTIONS_CLEANUP: "old-transactions-cleanup";
    readonly OLD_LOGS_CLEANUP: "old-logs-cleanup";
    readonly OLD_SESSIONS_CLEANUP: "old-sessions-cleanup";
    readonly DAILY_REPORT: "daily-report";
    readonly WEEKLY_REPORT: "weekly-report";
    readonly MONTHLY_REPORT: "monthly-report";
    readonly DISPUTE_REPORT: "dispute-report";
    readonly ESCALATE_URGENT_DISPUTES: "escalate-urgent-disputes";
    readonly DISPUTE_REMINDERS: "dispute-reminders";
    readonly SEND_EMAIL: "send-email";
    readonly SEND_SMS: "send-sms";
    readonly SEND_PUSH: "send-push";
    readonly RUN_DATA_RETENTION: "run-data-retention";
};
export interface QueueConfig {
    name: string;
    concurrency?: number;
    maxAttempts?: number;
    backoffDelay?: number;
    removeOnComplete?: number;
    removeOnFail?: number;
    delay?: number;
    priority?: number;
}
export declare const DEFAULT_QUEUE_CONFIG: QueueConfig;
export declare const QUEUE_CONFIGS: Record<string, QueueConfig>;
export declare class QueueManager {
    private static instance;
    private queues;
    private workers;
    private schedulers;
    private useFallback;
    private constructor();
    static getInstance(): QueueManager;
    private isRedisAvailable;
    private shouldUseFallbackImmediately;
    getQueue(name: string): Promise<Queue | any>;
    getWorker(name: string, processor: (job: Job | FallbackQueueJob) => Promise<any>): Promise<Worker | any>;
    getScheduler(name: string): Promise<any>;
    addJob<T = any>(queueName: string, jobType: string, data: T, options?: {
        delay?: number;
        priority?: number;
        attempts?: number;
        backoff?: number;
        removeOnComplete?: number;
        removeOnFail?: number;
    }): Promise<Job<T> | FallbackQueueJob<T>>;
    addRecurringJob<T = any>(queueName: string, jobType: string, data: T, pattern: string, options?: {
        priority?: number;
        attempts?: number;
        backoff?: number;
    }): Promise<Job<T> | FallbackQueueJob<T>>;
    getQueueStats(queueName: string): Promise<{
        name: string;
        waiting: any;
        active: any;
        completed: any;
        failed: any;
        delayed: any;
    }>;
    getAllQueueStats(): Promise<any[]>;
    cleanupOldJobs(queueName: string, olderThan?: number): Promise<number>;
    shutdown(): Promise<void>;
}
export declare const queueManager: QueueManager;
export type { Job, Queue, Worker };
