interface QueueJob<T = any> {
    id: string;
    name: string;
    data: T;
    options: {
        delay?: number;
        priority?: number;
        attempts?: number;
        backoff?: number;
    };
    createdAt: number;
    processedAt?: number;
    failedAt?: number;
    attempts: number;
    maxAttempts: number;
    status: 'waiting' | 'active' | 'completed' | 'failed' | 'delayed';
}
interface QueueStats {
    name: string;
    waiting: number;
    active: number;
    completed: number;
    failed: number;
    delayed: number;
}
declare class InMemoryQueue<T = any> {
    name: string;
    private jobs;
    private processors;
    private timers;
    private isProcessing;
    private concurrency;
    private maxAttempts;
    private backoffDelay;
    constructor(name: string, options?: {
        concurrency?: number;
        maxAttempts?: number;
        backoffDelay?: number;
    });
    add(jobName: string, data: T, options?: {
        delay?: number;
        priority?: number;
        attempts?: number;
        backoff?: number;
    }): Promise<QueueJob<T>>;
    process(processor: (job: QueueJob<T>) => Promise<any>): Promise<void>;
    private processNext;
    private processJob;
    getWaiting(): Promise<QueueJob<T>[]>;
    getActive(): Promise<QueueJob<T>[]>;
    getCompleted(): Promise<QueueJob<T>[]>;
    getFailed(): Promise<QueueJob<T>[]>;
    getDelayed(): Promise<QueueJob<T>[]>;
    getStats(): Promise<QueueStats>;
    close(): Promise<void>;
}
declare class InMemoryWorker<T = any> {
    name: string;
    private processor;
    private queue;
    constructor(name: string, processor: (job: QueueJob<T>) => Promise<any>, queue: InMemoryQueue<T>);
    start(): Promise<void>;
    close(): Promise<void>;
}
declare class InMemoryScheduler {
    name: string;
    private timers;
    constructor(name: string);
    close(): Promise<void>;
}
export declare class FallbackQueueManager {
    private static instance;
    private queues;
    private workers;
    private schedulers;
    private constructor();
    static getInstance(): FallbackQueueManager;
    getQueue(name: string, options?: {
        concurrency?: number;
        maxAttempts?: number;
        backoffDelay?: number;
    }): InMemoryQueue;
    getWorker(name: string, processor: (job: QueueJob) => Promise<any>): InMemoryWorker;
    getScheduler(name: string): InMemoryScheduler;
    addJob<T = any>(queueName: string, jobType: string, data: T, options?: {
        delay?: number;
        priority?: number;
        attempts?: number;
        backoff?: number;
    }): Promise<QueueJob<T>>;
    getQueueStats(queueName: string): Promise<QueueStats>;
    getAllQueueStats(): Promise<QueueStats[]>;
    shutdown(): Promise<void>;
}
export declare const fallbackQueueManager: FallbackQueueManager;
export type { QueueJob, QueueStats };
