"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.logBusinessEvent = exports.logSecurityEvent = exports.logError = exports.logRequest = exports.createChildLogger = exports.logger = void 0;
const pino_1 = __importDefault(require("pino"));
const env_1 = require("./env");
const createLogger = () => {
    const config = {
        level: env_1.env.LOG_LEVEL,
        timestamp: pino_1.default.stdTimeFunctions.isoTime,
        formatters: {
            level: (label) => {
                return { level: label };
            },
        },
        serializers: {
            req: pino_1.default.stdSerializers.req,
            res: pino_1.default.stdSerializers.res,
            err: pino_1.default.stdSerializers.err,
        },
    };
    if (env_1.env.NODE_ENV === 'development' && env_1.env.LOG_PRETTY_PRINT) {
        config.transport = {
            target: 'pino-pretty',
            options: {
                colorize: true,
                translateTime: 'SYS:standard',
                ignore: 'pid,hostname',
            },
        };
    }
    return (0, pino_1.default)(config);
};
exports.logger = createLogger();
const createChildLogger = (context, bindings) => {
    return exports.logger.child({ context, ...bindings });
};
exports.createChildLogger = createChildLogger;
const logRequest = (req, res, responseTime) => {
    exports.logger.info({
        type: 'request',
        method: req.method,
        url: req.url,
        statusCode: res.statusCode,
        responseTime,
        userAgent: req.get('User-Agent'),
        ip: req.ip,
        userId: req.user?.id,
    });
};
exports.logRequest = logRequest;
const logError = (error, context) => {
    exports.logger.error({
        type: 'error',
        message: error.message,
        stack: error.stack,
        ...context,
    });
};
exports.logError = logError;
const logSecurityEvent = (event, details) => {
    exports.logger.warn({
        type: 'security',
        event,
        ...details,
    });
};
exports.logSecurityEvent = logSecurityEvent;
const logBusinessEvent = (event, details) => {
    exports.logger.info({
        type: 'business',
        event,
        ...details,
    });
};
exports.logBusinessEvent = logBusinessEvent;
