"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComplianceConfig = exports.getRateLimitConfig = exports.getLoggingConfig = exports.getVerificationConfig = exports.getPaymentConfig = exports.getSecurityConfig = exports.getRedisConfig = exports.getDatabaseConfig = exports.getServerConfig = exports.isTest = exports.isProduction = exports.isDevelopment = exports.validateConfig = exports.createAppConfig = void 0;
__exportStar(require("./env"), exports);
__exportStar(require("./logger"), exports);
__exportStar(require("./rate-limit"), exports);
__exportStar(require("./security"), exports);
__exportStar(require("./database"), exports);
__exportStar(require("./redis"), exports);
const createAppConfig = async () => {
    const { env } = await Promise.resolve().then(() => __importStar(require('./env')));
    return {
        server: {
            port: env.PORT,
            environment: env.NODE_ENV,
            apiVersion: env.API_VERSION,
        },
        database: {
            uri: env.MONGODB_URI,
            options: {},
        },
        redis: {
            url: env.REDIS_URL || 'redis://localhost:6379',
            options: {},
        },
        security: {
            jwt: {
                secret: env.JWT_SECRET,
                expiresIn: env.JWT_EXPIRES_IN,
                refreshExpiresIn: env.JWT_REFRESH_EXPIRES_IN,
            },
            bcrypt: {
                rounds: env.BCRYPT_ROUNDS,
            },
            cors: {
                origins: env.CORS_ORIGIN.split(',').map((origin) => origin.trim()),
                credentials: env.CORS_CREDENTIALS,
            },
        },
        payment: {
            paystack: {
                ...(env.PAYSTACK_SECRET_KEY && { secretKey: env.PAYSTACK_SECRET_KEY }),
                ...(env.PAYSTACK_PUBLIC_KEY && { publicKey: env.PAYSTACK_PUBLIC_KEY }),
                ...(env.PAYSTACK_WEBHOOK_SECRET && { webhookSecret: env.PAYSTACK_WEBHOOK_SECRET }),
            },
            flutterwave: {
                ...(env.FLUTTERWAVE_SECRET_KEY && { secretKey: env.FLUTTERWAVE_SECRET_KEY }),
                ...(env.FLUTTERWAVE_PUBLIC_KEY && { publicKey: env.FLUTTERWAVE_PUBLIC_KEY }),
            },
        },
        verification: {
            nimc: {
                ...(env.NIMC_API_KEY && { apiKey: env.NIMC_API_KEY }),
                ...(env.NIMC_API_URL && { apiUrl: env.NIMC_API_URL }),
            },
            bvn: {
                ...(env.BVN_API_KEY && { apiKey: env.BVN_API_KEY }),
                ...(env.BVN_API_URL && { apiUrl: env.BVN_API_URL }),
            },
        },
        logging: {
            level: env.LOG_LEVEL,
            prettyPrint: env.LOG_PRETTY_PRINT,
        },
        rateLimit: {
            windowMs: env.RATE_LIMIT_WINDOW_MS,
            maxRequests: env.RATE_LIMIT_MAX_REQUESTS,
        },
        compliance: {
            ndpr: env.NDPR_COMPLIANCE,
            cbn: env.CBN_COMPLIANCE,
            dataRetentionDays: env.DATA_RETENTION_DAYS,
        },
    };
};
exports.createAppConfig = createAppConfig;
const validateConfig = async () => {
    try {
        const config = await (0, exports.createAppConfig)();
        if (!config.server.port || config.server.port <= 0) {
            throw new Error('Invalid server port configuration');
        }
        if (!config.database.uri) {
            throw new Error('Database URI is required');
        }
        if (!config.redis.url) {
            throw new Error('Redis URL is required');
        }
        if (!config.security.jwt.secret || config.security.jwt.secret.length < 32) {
            throw new Error('JWT secret must be at least 32 characters long');
        }
        if (!config.payment.paystack.secretKey) {
            throw new Error('Paystack secret key is required');
        }
        if (!config.verification.nimc.apiKey) {
            throw new Error('NIMC API key is required');
        }
        if (!config.verification.bvn.apiKey) {
            throw new Error('BVN API key is required');
        }
        console.log('Configuration validation passed');
        return true;
    }
    catch (error) {
        console.error('Configuration validation failed:', error);
        return false;
    }
};
exports.validateConfig = validateConfig;
const isDevelopment = () => {
    try {
        const { env } = require('./env');
        return env.NODE_ENV === 'development';
    }
    catch {
        return false;
    }
};
exports.isDevelopment = isDevelopment;
const isProduction = () => {
    try {
        const { env } = require('./env');
        return env.NODE_ENV === 'production';
    }
    catch {
        return false;
    }
};
exports.isProduction = isProduction;
const isTest = () => {
    try {
        const { env } = require('./env');
        return env.NODE_ENV === 'test';
    }
    catch {
        return false;
    }
};
exports.isTest = isTest;
const getServerConfig = async () => {
    const config = await (0, exports.createAppConfig)();
    return config.server;
};
exports.getServerConfig = getServerConfig;
const getDatabaseConfig = async () => {
    const config = await (0, exports.createAppConfig)();
    return config.database;
};
exports.getDatabaseConfig = getDatabaseConfig;
const getRedisConfig = async () => {
    const config = await (0, exports.createAppConfig)();
    return config.redis;
};
exports.getRedisConfig = getRedisConfig;
const getSecurityConfig = async () => {
    const config = await (0, exports.createAppConfig)();
    return config.security;
};
exports.getSecurityConfig = getSecurityConfig;
const getPaymentConfig = async () => {
    const config = await (0, exports.createAppConfig)();
    return config.payment;
};
exports.getPaymentConfig = getPaymentConfig;
const getVerificationConfig = async () => {
    const config = await (0, exports.createAppConfig)();
    return config.verification;
};
exports.getVerificationConfig = getVerificationConfig;
const getLoggingConfig = async () => {
    const config = await (0, exports.createAppConfig)();
    return config.logging;
};
exports.getLoggingConfig = getLoggingConfig;
const getRateLimitConfig = async () => {
    const config = await (0, exports.createAppConfig)();
    return config.rateLimit;
};
exports.getRateLimitConfig = getRateLimitConfig;
const getComplianceConfig = async () => {
    const config = await (0, exports.createAppConfig)();
    return config.compliance;
};
exports.getComplianceConfig = getComplianceConfig;
