export * from './env';
export * from './logger';
export * from './rate-limit';
export * from './security';
export * from './database';
export * from './redis';
export interface AppConfig {
    server: {
        port: number;
        environment: string;
        apiVersion: string;
    };
    database: {
        uri: string;
        options: any;
    };
    redis: {
        url: string;
        options: any;
    };
    security: {
        jwt: {
            secret: string;
            expiresIn: string;
            refreshExpiresIn: string;
        };
        bcrypt: {
            rounds: number;
        };
        cors: {
            origins: string[];
            credentials: boolean;
        };
    };
    payment: {
        paystack: {
            secretKey?: string;
            publicKey?: string;
            webhookSecret?: string;
        };
        flutterwave: {
            secretKey?: string;
            publicKey?: string;
        };
    };
    verification: {
        nimc: {
            apiKey?: string;
            apiUrl?: string;
        };
        bvn: {
            apiKey?: string;
            apiUrl?: string;
        };
    };
    logging: {
        level: string;
        prettyPrint: boolean;
    };
    rateLimit: {
        windowMs: number;
        maxRequests: number;
    };
    compliance: {
        ndpr: boolean;
        cbn: boolean;
        dataRetentionDays: number;
    };
}
export declare const createAppConfig: () => Promise<AppConfig>;
export declare const validateConfig: () => Promise<boolean>;
export declare const isDevelopment: () => boolean;
export declare const isProduction: () => boolean;
export declare const isTest: () => boolean;
export declare const getServerConfig: () => Promise<{
    port: number;
    environment: string;
    apiVersion: string;
}>;
export declare const getDatabaseConfig: () => Promise<{
    uri: string;
    options: any;
}>;
export declare const getRedisConfig: () => Promise<{
    url: string;
    options: any;
}>;
export declare const getSecurityConfig: () => Promise<{
    jwt: {
        secret: string;
        expiresIn: string;
        refreshExpiresIn: string;
    };
    bcrypt: {
        rounds: number;
    };
    cors: {
        origins: string[];
        credentials: boolean;
    };
}>;
export declare const getPaymentConfig: () => Promise<{
    paystack: {
        secretKey?: string;
        publicKey?: string;
        webhookSecret?: string;
    };
    flutterwave: {
        secretKey?: string;
        publicKey?: string;
    };
}>;
export declare const getVerificationConfig: () => Promise<{
    nimc: {
        apiKey?: string;
        apiUrl?: string;
    };
    bvn: {
        apiKey?: string;
        apiUrl?: string;
    };
}>;
export declare const getLoggingConfig: () => Promise<{
    level: string;
    prettyPrint: boolean;
}>;
export declare const getRateLimitConfig: () => Promise<{
    windowMs: number;
    maxRequests: number;
}>;
export declare const getComplianceConfig: () => Promise<{
    ndpr: boolean;
    cbn: boolean;
    dataRetentionDays: number;
}>;
