import { z } from 'zod';
declare const envSchema: z.ZodObject<{
    NODE_ENV: z.ZodDefault<z.ZodEnum<["development", "production", "test"]>>;
    PORT: z.ZodDefault<z.ZodPipeline<z.ZodString, z.ZodNumber>>;
    API_VERSION: z.ZodDefault<z.ZodString>;
    MONGODB_URI: z.ZodString;
    MONGODB_URI_PROD: z.ZodOptional<z.ZodString>;
    JWT_SECRET: z.ZodString;
    JWT_EXPIRES_IN: z.ZodDefault<z.ZodString>;
    JWT_REFRESH_EXPIRES_IN: z.ZodDefault<z.ZodString>;
    FIELD_ENCRYPTION_KEY: z.ZodOptional<z.ZodString>;
    REDIS_URL: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    REDIS_PASSWORD: z.ZodOptional<z.ZodString>;
    REDIS_OPTIONAL: z.ZodDefault<z.ZodEffects<z.ZodBoolean, boolean, unknown>>;
    REDIS_TLS: z.ZodDefault<z.ZodEffects<z.ZodBoolean, boolean, unknown>>;
    REDIS_FORCE_SSL: z.ZodOptional<z.ZodString>;
    PAYSTACK_SECRET_KEY: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    PAYSTACK_PUBLIC_KEY: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    PAYSTACK_WEBHOOK_SECRET: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    FLUTTERWAVE_SECRET_KEY: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    FLUTTERWAVE_PUBLIC_KEY: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    ASPFIY_SECRET_KEY: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    ASPFIY_PUBLIC_KEY: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    ASPFIY_WEBHOOK_SECRET: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    ASPFIY_BASE_URL: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    ASPFIY_USE_STUB: z.ZodDefault<z.ZodEffects<z.ZodBoolean, boolean, unknown>>;
    ASPFIY_FORCE_STUB: z.ZodDefault<z.ZodEffects<z.ZodBoolean, boolean, unknown>>;
    NIMC_API_KEY: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    NIMC_API_URL: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    BVN_API_KEY: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    BVN_API_URL: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    BCRYPT_ROUNDS: z.ZodDefault<z.ZodPipeline<z.ZodString, z.ZodNumber>>;
    RATE_LIMIT_WINDOW_MS: z.ZodDefault<z.ZodPipeline<z.ZodString, z.ZodNumber>>;
    RATE_LIMIT_MAX_REQUESTS: z.ZodDefault<z.ZodPipeline<z.ZodString, z.ZodNumber>>;
    LOG_LEVEL: z.ZodDefault<z.ZodEnum<["error", "warn", "info", "debug"]>>;
    LOG_PRETTY_PRINT: z.ZodDefault<z.ZodEffects<z.ZodBoolean, boolean, unknown>>;
    CORS_ORIGIN: z.ZodDefault<z.ZodString>;
    CORS_CREDENTIALS: z.ZodDefault<z.ZodEffects<z.ZodBoolean, boolean, unknown>>;
    MAX_FILE_SIZE: z.ZodDefault<z.ZodPipeline<z.ZodString, z.ZodNumber>>;
    UPLOAD_PATH: z.ZodDefault<z.ZodString>;
    SMTP_HOST: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    SMTP_PORT: z.ZodDefault<z.ZodPipeline<z.ZodString, z.ZodNumber>>;
    SMTP_USER: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    SMTP_PASS: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    SMS_API_KEY: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    SMS_API_URL: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    APP_NAME: z.ZodDefault<z.ZodString>;
    APP_URL: z.ZodString;
    FRONTEND_URL: z.ZodString;
    NDPR_COMPLIANCE: z.ZodDefault<z.ZodEffects<z.ZodBoolean, boolean, unknown>>;
    CBN_COMPLIANCE: z.ZodDefault<z.ZodEffects<z.ZodBoolean, boolean, unknown>>;
    DATA_RETENTION_DAYS: z.ZodDefault<z.ZodPipeline<z.ZodString, z.ZodNumber>>;
    SENTRY_DSN: z.ZodOptional<z.ZodString>;
    NEW_RELIC_LICENSE_KEY: z.ZodOptional<z.ZodString>;
    ASB_DATA_BASE_URL: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    ASB_DATA_API_KEY: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    ASB_DATA_SECRET_KEY: z.ZodOptional<z.ZodString>;
    VTU_SANDBOX_MODE: z.ZodDefault<z.ZodEffects<z.ZodBoolean, boolean, unknown>>;
    VTU_DEFAULT_PROVIDER: z.ZodDefault<z.ZodEnum<["asbdata", "mock"]>>;
    UNIFY_BASE_URL: z.ZodDefault<z.ZodString>;
    UNIFY_API_KEY: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    UNIFY_WEBHOOK_SECRET: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    S8V_BASE_URL: z.ZodDefault<z.ZodString>;
    S8V_API_KEY: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"">, z.ZodUndefined]>>;
    VERIFICATION_SANDBOX_MODE: z.ZodDefault<z.ZodEffects<z.ZodBoolean, boolean, unknown>>;
}, "strip", z.ZodTypeAny, {
    NODE_ENV: "development" | "production" | "test";
    PORT: number;
    API_VERSION: string;
    MONGODB_URI: string;
    JWT_SECRET: string;
    JWT_EXPIRES_IN: string;
    JWT_REFRESH_EXPIRES_IN: string;
    REDIS_OPTIONAL: boolean;
    REDIS_TLS: boolean;
    ASPFIY_USE_STUB: boolean;
    ASPFIY_FORCE_STUB: boolean;
    BCRYPT_ROUNDS: number;
    RATE_LIMIT_WINDOW_MS: number;
    RATE_LIMIT_MAX_REQUESTS: number;
    LOG_LEVEL: "error" | "warn" | "info" | "debug";
    LOG_PRETTY_PRINT: boolean;
    CORS_ORIGIN: string;
    CORS_CREDENTIALS: boolean;
    MAX_FILE_SIZE: number;
    UPLOAD_PATH: string;
    SMTP_PORT: number;
    APP_NAME: string;
    APP_URL: string;
    FRONTEND_URL: string;
    NDPR_COMPLIANCE: boolean;
    CBN_COMPLIANCE: boolean;
    DATA_RETENTION_DAYS: number;
    VTU_SANDBOX_MODE: boolean;
    VTU_DEFAULT_PROVIDER: "asbdata" | "mock";
    UNIFY_BASE_URL: string;
    S8V_BASE_URL: string;
    VERIFICATION_SANDBOX_MODE: boolean;
    MONGODB_URI_PROD?: string | undefined;
    FIELD_ENCRYPTION_KEY?: string | undefined;
    REDIS_URL?: string | undefined;
    REDIS_PASSWORD?: string | undefined;
    REDIS_FORCE_SSL?: string | undefined;
    PAYSTACK_SECRET_KEY?: string | undefined;
    PAYSTACK_PUBLIC_KEY?: string | undefined;
    PAYSTACK_WEBHOOK_SECRET?: string | undefined;
    FLUTTERWAVE_SECRET_KEY?: string | undefined;
    FLUTTERWAVE_PUBLIC_KEY?: string | undefined;
    ASPFIY_SECRET_KEY?: string | undefined;
    ASPFIY_PUBLIC_KEY?: string | undefined;
    ASPFIY_WEBHOOK_SECRET?: string | undefined;
    ASPFIY_BASE_URL?: string | undefined;
    NIMC_API_KEY?: string | undefined;
    NIMC_API_URL?: string | undefined;
    BVN_API_KEY?: string | undefined;
    BVN_API_URL?: string | undefined;
    SMTP_HOST?: string | undefined;
    SMTP_USER?: string | undefined;
    SMTP_PASS?: string | undefined;
    SMS_API_KEY?: string | undefined;
    SMS_API_URL?: string | undefined;
    SENTRY_DSN?: string | undefined;
    NEW_RELIC_LICENSE_KEY?: string | undefined;
    ASB_DATA_BASE_URL?: string | undefined;
    ASB_DATA_API_KEY?: string | undefined;
    ASB_DATA_SECRET_KEY?: string | undefined;
    UNIFY_API_KEY?: string | undefined;
    UNIFY_WEBHOOK_SECRET?: string | undefined;
    S8V_API_KEY?: string | undefined;
}, {
    MONGODB_URI: string;
    JWT_SECRET: string;
    APP_URL: string;
    FRONTEND_URL: string;
    NODE_ENV?: "development" | "production" | "test" | undefined;
    PORT?: string | undefined;
    API_VERSION?: string | undefined;
    MONGODB_URI_PROD?: string | undefined;
    JWT_EXPIRES_IN?: string | undefined;
    JWT_REFRESH_EXPIRES_IN?: string | undefined;
    FIELD_ENCRYPTION_KEY?: string | undefined;
    REDIS_URL?: string | undefined;
    REDIS_PASSWORD?: string | undefined;
    REDIS_OPTIONAL?: unknown;
    REDIS_TLS?: unknown;
    REDIS_FORCE_SSL?: string | undefined;
    PAYSTACK_SECRET_KEY?: string | undefined;
    PAYSTACK_PUBLIC_KEY?: string | undefined;
    PAYSTACK_WEBHOOK_SECRET?: string | undefined;
    FLUTTERWAVE_SECRET_KEY?: string | undefined;
    FLUTTERWAVE_PUBLIC_KEY?: string | undefined;
    ASPFIY_SECRET_KEY?: string | undefined;
    ASPFIY_PUBLIC_KEY?: string | undefined;
    ASPFIY_WEBHOOK_SECRET?: string | undefined;
    ASPFIY_BASE_URL?: string | undefined;
    ASPFIY_USE_STUB?: unknown;
    ASPFIY_FORCE_STUB?: unknown;
    NIMC_API_KEY?: string | undefined;
    NIMC_API_URL?: string | undefined;
    BVN_API_KEY?: string | undefined;
    BVN_API_URL?: string | undefined;
    BCRYPT_ROUNDS?: string | undefined;
    RATE_LIMIT_WINDOW_MS?: string | undefined;
    RATE_LIMIT_MAX_REQUESTS?: string | undefined;
    LOG_LEVEL?: "error" | "warn" | "info" | "debug" | undefined;
    LOG_PRETTY_PRINT?: unknown;
    CORS_ORIGIN?: string | undefined;
    CORS_CREDENTIALS?: unknown;
    MAX_FILE_SIZE?: string | undefined;
    UPLOAD_PATH?: string | undefined;
    SMTP_HOST?: string | undefined;
    SMTP_PORT?: string | undefined;
    SMTP_USER?: string | undefined;
    SMTP_PASS?: string | undefined;
    SMS_API_KEY?: string | undefined;
    SMS_API_URL?: string | undefined;
    APP_NAME?: string | undefined;
    NDPR_COMPLIANCE?: unknown;
    CBN_COMPLIANCE?: unknown;
    DATA_RETENTION_DAYS?: string | undefined;
    SENTRY_DSN?: string | undefined;
    NEW_RELIC_LICENSE_KEY?: string | undefined;
    ASB_DATA_BASE_URL?: string | undefined;
    ASB_DATA_API_KEY?: string | undefined;
    ASB_DATA_SECRET_KEY?: string | undefined;
    VTU_SANDBOX_MODE?: unknown;
    VTU_DEFAULT_PROVIDER?: "asbdata" | "mock" | undefined;
    UNIFY_BASE_URL?: string | undefined;
    UNIFY_API_KEY?: string | undefined;
    UNIFY_WEBHOOK_SECRET?: string | undefined;
    S8V_BASE_URL?: string | undefined;
    S8V_API_KEY?: string | undefined;
    VERIFICATION_SANDBOX_MODE?: unknown;
}>;
export declare const env: {
    NODE_ENV: "development" | "production" | "test";
    PORT: number;
    API_VERSION: string;
    MONGODB_URI: string;
    JWT_SECRET: string;
    JWT_EXPIRES_IN: string;
    JWT_REFRESH_EXPIRES_IN: string;
    REDIS_OPTIONAL: boolean;
    REDIS_TLS: boolean;
    ASPFIY_USE_STUB: boolean;
    ASPFIY_FORCE_STUB: boolean;
    BCRYPT_ROUNDS: number;
    RATE_LIMIT_WINDOW_MS: number;
    RATE_LIMIT_MAX_REQUESTS: number;
    LOG_LEVEL: "error" | "warn" | "info" | "debug";
    LOG_PRETTY_PRINT: boolean;
    CORS_ORIGIN: string;
    CORS_CREDENTIALS: boolean;
    MAX_FILE_SIZE: number;
    UPLOAD_PATH: string;
    SMTP_PORT: number;
    APP_NAME: string;
    APP_URL: string;
    FRONTEND_URL: string;
    NDPR_COMPLIANCE: boolean;
    CBN_COMPLIANCE: boolean;
    DATA_RETENTION_DAYS: number;
    VTU_SANDBOX_MODE: boolean;
    VTU_DEFAULT_PROVIDER: "asbdata" | "mock";
    UNIFY_BASE_URL: string;
    S8V_BASE_URL: string;
    VERIFICATION_SANDBOX_MODE: boolean;
    MONGODB_URI_PROD?: string | undefined;
    FIELD_ENCRYPTION_KEY?: string | undefined;
    REDIS_URL?: string | undefined;
    REDIS_PASSWORD?: string | undefined;
    REDIS_FORCE_SSL?: string | undefined;
    PAYSTACK_SECRET_KEY?: string | undefined;
    PAYSTACK_PUBLIC_KEY?: string | undefined;
    PAYSTACK_WEBHOOK_SECRET?: string | undefined;
    FLUTTERWAVE_SECRET_KEY?: string | undefined;
    FLUTTERWAVE_PUBLIC_KEY?: string | undefined;
    ASPFIY_SECRET_KEY?: string | undefined;
    ASPFIY_PUBLIC_KEY?: string | undefined;
    ASPFIY_WEBHOOK_SECRET?: string | undefined;
    ASPFIY_BASE_URL?: string | undefined;
    NIMC_API_KEY?: string | undefined;
    NIMC_API_URL?: string | undefined;
    BVN_API_KEY?: string | undefined;
    BVN_API_URL?: string | undefined;
    SMTP_HOST?: string | undefined;
    SMTP_USER?: string | undefined;
    SMTP_PASS?: string | undefined;
    SMS_API_KEY?: string | undefined;
    SMS_API_URL?: string | undefined;
    SENTRY_DSN?: string | undefined;
    NEW_RELIC_LICENSE_KEY?: string | undefined;
    ASB_DATA_BASE_URL?: string | undefined;
    ASB_DATA_API_KEY?: string | undefined;
    ASB_DATA_SECRET_KEY?: string | undefined;
    UNIFY_API_KEY?: string | undefined;
    UNIFY_WEBHOOK_SECRET?: string | undefined;
    S8V_API_KEY?: string | undefined;
};
export declare const getMongoUri: () => string;
export declare const getCorsOrigins: () => string[];
export type Env = z.infer<typeof envSchema>;
export {};
