import mongoose from 'mongoose';
export declare const mongoOptions: mongoose.ConnectOptions;
export declare const databaseConfig: {
    uri: string;
    options: mongoose.ConnectOptions;
    events: {
        connected: string;
        disconnected: string;
        error: string;
        reconnected: string;
    };
    retry: {
        attempts: number;
        delay: number;
        backoff: number;
    };
    healthCheck: {
        enabled: boolean;
        interval: number;
        timeout: number;
    };
    backup: {
        enabled: boolean;
        schedule: string;
        retention: number;
    };
    monitoring: {
        enabled: boolean;
        slowQueryThreshold: number;
        logQueries: boolean;
    };
};
export declare const mongooseConfig: {
    plugins: never[];
    schemaOptions: {
        timestamps: boolean;
        toJSON: {
            transform: (_doc: any, ret: any) => any;
        };
        toObject: {
            transform: (_doc: any, ret: any) => any;
        };
    };
    modelOptions: {};
};
export declare const connectDatabase: () => Promise<void>;
export declare const disconnectDatabase: () => Promise<void>;
export declare const getDatabaseStatus: () => string;
export declare const checkDatabaseHealth: () => Promise<boolean>;
export declare const gracefulShutdown: (signal: string) => Promise<void>;
